﻿/**
 * Affiche et maintient à jour les marqueurs position de tout les joueurs
 * A exécuter dans un fil d'exécution dédié
 * 
 * Pour lancer le script chez un joueur, exécutez l'instruction suivante : nul = [] execVM "afficher_marqueurs_joueurs.sqf";
 * Pour arrêter d'afficher les marqueur, exécutez l'instruction suivante : R3F_afficher_marqueur_joueurs = false;
 */



private ["_liste_noms_marqueurs"];

_liste_noms_marqueurs = [];

while {R3F_afficher_marqueur_joueurs} do
{
	private ["_nouvelle_liste_marqueurs", "_liste_joueurs", "_i"];
	
	_nouvelle_liste_marqueurs = [];
	
	// Pour chaque joueur, à intervalle régulier
	_liste_joueurs = switchableUnits + playableUnits;
	for [{_i = 0}, {_i < count _liste_joueurs}, {_i = _i + 1}] do
	{
		private ["_joueur", "_marqueur"];
		
		_joueur = _liste_joueurs select _i;
		
		if (isPlayer _joueur && alive _joueur) then
		{
			_marqueur = "mark_" + name _joueur;
			
			// On crée le marqueur s'il n'existe pas encore
			if (getMarkerPos _marqueur distance [0, 0] == 0) then
			{
				_marqueur = createMarkerLocal [_marqueur, [0, 0]];
				_marqueur setMarkerTypeLocal "Arrow";
				_marqueur setMarkerColorLocal "ColorGreen";
				_marqueur setMarkerSizeLocal [0.5, 0.5];
				_marqueur setMarkerTextLocal format ["%1", (name _joueur)];
			};
			
			// Mise à jour de la position et direction
			_marqueur setMarkerPosLocal (getPos (vehicle _joueur));
			_marqueur setMarkerDirLocal (getDir (vehicle _joueur));
			
			_nouvelle_liste_marqueurs = _nouvelle_liste_marqueurs + [_marqueur];
		};
		
		sleep (1/count _liste_joueurs);
	};
	
	// On supprime tout les marqueurs qui n'ont pas été mis à jour (joueur mort ou déconnecté)
	{
		deleteMarkerLocal _x;
	} forEach (_liste_noms_marqueurs - _nouvelle_liste_marqueurs);
	
	_liste_noms_marqueurs = _nouvelle_liste_marqueurs;
};

// On supprime tout les marqueurs créés
{
	deleteMarkerLocal _x;
} forEach _liste_noms_marqueurs;